/*
 * Decompiled with CFR 0.152.
 */
package strategies.ai;

import core.states.GameState;
import entities.Entity;
import entities.creatures.enemies.SivirEntity;
import entities.missiles.sona.SonaAbilityREntity;
import java.util.ArrayList;
import strategies.ai.Ai;
import util.ResourceManager;

public final class SivirAi
extends Ai {
    private SonaAbilityREntity sonaR = null;
    private int lastSonaRY = 0;

    @Override
    public void calculate() {
        SivirEntity entity = (SivirEntity)this.entity;
        if (entity.isStunned()) {
            return;
        }
        if (this.sonaR == null) {
            ArrayList<Entity> entities = GameState.get().getEntities();
            for (Entity ent : entities) {
                if (!(ent instanceof SonaAbilityREntity)) continue;
                this.sonaR = (SonaAbilityREntity)ent;
                break;
            }
        } else {
            if ((double)(this.sonaR.getY() + this.sonaR.getH()) < this.y || this.sonaR.getY() == this.lastSonaRY) {
                this.sonaR = null;
            } else {
                this.lastSonaRY = this.sonaR.getY();
            }
            entity.useAbilityE();
        }
        if (this.dx < 0.0 && this.x <= 0.0 || this.dx > 0.0 && this.x >= ResourceManager.get().getDimension().getWidth() - (double)entity.getW()) {
            this.dx = -this.dx;
        }
        if (this.dy < 0.0 && this.y <= 10.0 || this.dy > 0.0 && this.y >= 300.0) {
            this.dy = -this.dy;
        }
        if (GameState.get().isAttackDelayOver()) {
            int sivirShotChance;
            switch (GameState.get().getDifficulty()) {
                case HARD: {
                    sivirShotChance = 114000;
                    break;
                }
                case LEGENDARY: {
                    sivirShotChance = 109000;
                    break;
                }
                default: {
                    sivirShotChance = 105000;
                }
            }
            if (this.random.nextInt(sivirShotChance) > 100000) {
                entity.useShot();
            }
            if (this.random.nextInt(105000) > 100000) {
                entity.useAbilityQ();
            }
            entity.useAbilityR();
        }
    }
}

